Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer


Public Const WH_CALLWNDPROC = 4
Public Const WH_CALLWNDPROCRET = 12
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6
Public Const WH_KEYBOARD_LL = 13

Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Private Const SW_SHOWNORMAL = 1
Private Const VK_LWIN = &H5B
Private Const VK_DELELTE = &H2E
Private Const VK_CONTROL = &H11
Private Const LLKHF_ALTDOWN = &H20

Public Type KBDLLHOOKSTRUCT
    vkCode As Long
    scanCode As Long
    flags As Long
    time As Long
    dwExtraInfo As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type


Private hHook As Long
Public IsHooked As Boolean


'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetKeyboardHook()
    If IsHooked Then
        MsgBox "Don't hook WH_KEYBOARD_LL twice or you will be unable to unhook it."
    Else
        'This must be set up as a system-wide hook
        hHook = SetWindowsHookEx(WH_KEYBOARD_LL, AddressOf WndLLKeyBoardProc, App.hInstance, 0)
        IsHooked = True
    End If
End Sub


Public Sub RemoveKeyboardHook()
    Dim RetVal As Long
    RetVal = UnhookWindowsHookEx(hHook)
    IsHooked = False
End Sub


Public Function WndLLKeyBoardProc(ByVal uCode As Long, ByVal wParam As Long, lParam As KBDLLHOOKSTRUCT) As Long
    Dim bCtrlKeyDown As Boolean
    Dim bAltKeyPressed As Boolean
    Dim iCtrlKeyState As Integer
    
    If uCode >= 0 Then
        Select Case uCode
            Case HC_ACTION
                'If a DELETE key is pulled from the queue then discard it.
                If Hex$(lParam.vkCode) = "2E" Then
                    WndLLKeyBoardProc = 1
                    Exit Function
                End If

'
'UNCOMMENT THIS SECTION TO
'SEE HOW THIS HOOK AFFECTS
'THE CTRL+ALT+DEL KEY COMBINATION
'
'                iCtrlKeyState = GetAsyncKeyState(VK_CONTROL)
'                If (iCtrlKeyState And &H8000) = &H8000 Then
'                    bCtrlKeyDown = True
'                Else
'                    bCtrlKeyDown = False
'                End If
'
'                If (lParam.flags And LLKHF_ALTDOWN) = LLKHF_ALTDOWN Then
'                    bAltKeyPressed = True
'                Else
'                    bAltKeyPressed = False
'                End If
'
'                If ((Hex$(lParam.vkCode) = "2E") And bCtrlKeyDown And (bAltKeyPressed)) Then
'                    ''Returning false still allows the CTRL-ALT-DEL to be sent to the system.
'                    ''Returning false for any other characters disallows it to be sent to the focus window.
'                    WndLLKeyBoardProc = 1
'                    Exit Function
'                End If
            Case HC_NOREMOVE
                'The message has not been removed from the message queue
        End Select
    End If
        
    WndLLKeyBoardProc = CallNextHookEx(hHook, uCode, wParam, lParam)
End Function

